\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{SPAICE}[2025/09/29 modified article class]

% Passes and class options to the underlying article class
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions

% Load LaTeX's article class
\PassOptionsToClass{10pt,twocolumn,a4paper}{article}
\LoadClass{article}

% Page layout
\RequirePackage{geometry}
\geometry{
    left=2cm,
    right=2cm,
    top=3cm,
    bottom=3cm,
    headheight=12.13945pt % Minimal head height recommended by fancyhdr
}
\setlength{\columnsep}{15pt}
\pagestyle{empty}

% Double blind review.
% First, we define a class option
\newif\ifdoubleblind
\DeclareOption{doubleblind}{\doubleblindtrue}
% pass other options to the article class directly
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax

% Colors
\RequirePackage{xcolor}
\definecolor{newblue}{RGB}{0,57,158}

% Hyperref
\RequirePackage{hyperref}
\hypersetup{
  colorlinks   = true, %Colours links instead of boxes
  urlcolor     = newblue, %Colour for external hyperlinks
  linkcolor    = newblue, %Colour of internal links
  citecolor   = newblue %Colour of citations
}
% If authors are hidden, also clear the PDF metadata author field.
\ifdoubleblind
  \hypersetup{pdfauthor={},pdfcreator={}}
\fi

% Define the placeholder anonymous author names
\newcommand\anonymousauthorname{Anonymous Author(s)}

\makeatletter

% If doubleblind, blank the internal \@author early (works even if \maketitle is delayed)
\ifdoubleblind
  % Remove any \thanks content and similar footnote reveals
  \let\thanks\@gobble
  % Replace the stored author token to avoid accidental leaks
  \gdef\@author{\anonymousauthorname}
\fi

% Patch \maketitle to show anonymized authors when needed
\renewcommand\maketitle{%
  \par
  \begingroup
    \renewcommand\thefootnote{\fnsymbol{footnote}}%
    \def\@makefnmark{\hbox{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
      \hb@xt@1.8em{%
        \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \twocolumn[\@maketitle]%
    \else
      \newpage
      \global\@topnum\z@   % no floats at top of page
      \@maketitle
      \fi
    \thispagestyle{fancy}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \let\thanks\relax
  \let\maketitle\relax
}

% The actual title layout
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
    {\LARGE\bfseries \@title \par}%
    \vskip 1.0em%
    {\large
      \ifdoubleblind
        \anonymousauthorname
      \else
        \@author
      \fi
      \par
    }
  \end{center}%
  \vskip 1.5em
}

\makeatother

% Handle acknowledgments section, which should be removed during double blind
\RequirePackage{environ}
\NewEnviron{acknowledgments}{%
  \ifdoubleblind
    % hide entirely
  \else
    \section{Acknowledgments}%
    \BODY
  \fi
}


% Author block style
\RequirePackage{authblk}
\renewcommand\Authands{, }
\renewcommand\Affilfont{\itshape\small}

% Abstract style
\renewenvironment{abstract}
 {\noindent\small\bfseries}

% Set Text style
\PassOptionsToPackage{utf8}{inputenc} % allow utf-8 input
\RequirePackage{inputenc}
\PassOptionsToPackage{T1}{fontenc}    % use 8-bit T1 fonts
\RequirePackage{fontenc}
%\RequirePackage{kpfonts}  
%\linespread{1.05}   
\RequirePackage{libertinus}
% \parindent 15pt
% \parskip 1.05mm
\RequirePackage{microtype}

% Image package
\RequirePackage{graphicx}

% Tables package
\RequirePackage{booktabs}

% Math packages
\RequirePackage{amsmath}
\RequirePackage{amssymb}

% Bibliography settings
\RequirePackage[giveninits=true,style=nature,sorting=none,citestyle=numeric-comp, maxcitenames = 6]{biblatex}
\AtEveryBibitem{\clearfield{note}}
\AtEveryBibitem{\clearfield{language}} 
\renewcommand*{\bibfont}{\footnotesize}

% Caption settings
\PassOptionsToPackage{font=small,labelfont={bf},figurename=Figure,tablename=Table}{caption}
\RequirePackage{caption}
\renewcommand{\thetable}{\arabic{table}}

% Section head settings
\RequirePackage{titlesec}
\titleformat{\section}{\normalfont\Large\raggedright\bfseries}{\thesection}{1em}{}
\titleformat{\subsection}{\normalfont\large\raggedright\bfseries}{\thesubsection}{1em}{}

% References
\PassOptionsToPackage{noabbrev,nameinlink,capitalise}{cleveref}
\RequirePackage{cleveref}

% Header
\RequirePackage{fancyhdr}
\pagestyle{fancy}
\renewcommand{\headrulewidth}{0pt}
\fancyhead{} % Clear headers
% \fancyhead[C]{3\textsuperscript{rd} Conference on AI in and for Space -- SPAICE 2026}
% \fancyfoot{} % No footers for submissions
\fancyfoot[L]{\footnotesize 3\textsuperscript{rd} Conference on AI in and for Space (SPAICE 2026)\\ 
© 2026 \ifdoubleblind\anonymousauthorname\else\AuthorShort{}\fi, licenced via CC BY 4.0.}
\fancyfoot[C]{}
\endinput